local P1, P2, P1Score, P2Score
local difficulty, sTable
local songName= GAMESTATE:GetCurrentSong():GetSongDir() -- Looks for Song



local version = tonumber(string.match(ProductID(),'%d+%.?%d*$')) or 5.0;
if version > 5.1 then
	SCREENMAN:SystemMessage('Sorry, this song was made for SM 5.1');
end

local WideScale = function(AR4_3, AR16_9)
	-- return scale( SCREEN_WIDTH, 640, 854, AR4_3, AR16_9 )
	local w = 480 * PREFSMAN:GetPreference("DisplayAspectRatio")
	return scale( w, 640, 854, AR4_3, AR16_9 )
 end


local SlightFade = function(alpha)
	for player in ivalues(GAMESTATE:GetHumanPlayers()) do
	   
	   -- Get the player ActorFrame on ScreenGameplay.
	   -- It's a direct child of the screen and named "PlayerP1" for P1
	   -- and "PlayerP2" for P2.  This is currently hardcoded in the SM5 engine.
	   --
	   -- note: ScreenEdit does not name its notefield actor and I don't 
	   --       know how to get a reference to it from Lua.
	   local name = ("Player%s"):format( ToEnumShortString(player) )
	   
	   -- get a reference to the player ActorFrame
	   local player_af = SCREENMAN:GetTopScreen():GetChild( name )
	   
	   -- if the player ActorFrame was found (it won't be in Edit Mode)
	   if player_af then
		  -- Get specificially the NoteField out of the player ActorFrame.
		  -- It is a named child ("NoteField"), hardcoded in the SM5 engine.
		  local notefield = player_af:GetChild("NoteField")
		  
		  -- if the notefield was found (it should be, but hey)
		  if notefield then
			 
			 -- for each column in the NoteField
			 -- there are 4 columns in dance single, 8 in dance double, 5 in pump single, etc.
			 for i, column in ipairs(notefield:get_column_actors()) do
				column:diffusealpha(alpha)
			 end
		  end
	   end
	end
 end

 local function Handler_mod_internal(str, pn) -- Applies Players options to not be disabled-
	local ps= GAMESTATE:GetPlayerState(pn)
	local pmods= ps:GetPlayerOptionsString('ModsLevel_Song')
	ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
	-- GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function Handler_mod(str) -- Looks for many players are on the screen 
	for i=1,2 do
		Handler_mod_internal(str, 'PlayerNumber_P' .. i)
	end
end

local function Handler_init() -- Useful for command shorcuts
	if SCREENMAN:GetTopScreen():GetChild('PlayerP1')  then
		P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
	end
	if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
		P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
	end


	if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P1Score')  then
		P1Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P1Score')
	end
	if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P2Score') then
		P2Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P2Score')
	end


	fgcurcommand = 0;
	wndr_skewx=0.3;
	checked = false;
	--lua course :D	/ timed mod management
	--53
	--73
	--112
	--168
	--227
	--250
	--320	


	--77
--127
--143

--163*
--176*
--237
--252
--289
--307

	curmod = 1;		
	--{beat,'mod'},
	mods = {
		{76,'*0.5 15% dark, *0.5 15% Tipsy, *0.5 35% stealth, *0.3 10% Bumpy'},
		{532,'*1 no dark, *1 no Tipsy, *1 no stealth, *1 no Bumpy'},
		{597,'*0.5 35% dark, *0.5 20% stealth, *0.25 20% Drunk'},
		{597,'*0.5 no dark, *1 no stealth, *1 no Drunk'},
		{613,'*0.5 45% dark, *0.5 35% Tipsy, *0.5 35% stealth, *0.3 25% Bumpy'},
		{1054,'*0.5 10% dark, *2 no Tipsy, *0.5 10% stealth, *2 no Bumpy'},
	}
	--SCREAMING GUMBALL / timed message broadcaster
	curmessage = 1;
	
	--{beat,message,ignoreIfAhead}
	
	messages = {
		{67, 'NoDoor'},
		{76, 'Paradise'},
		{612, 'LimeAway'},
		{613.75, 'Paradise2'},
		{1050, 'Apples'}

	}
	
end

local function Handler_update() -- Updates the command to look for the players at the start of the song.

	if GAMESTATE:GetSongBeat()>=0.1 and not checked then
		
		screen = SCREENMAN:GetTopScreen()
		
		checked = true;
		
	end

	local beat = GAMESTATE:GetSongBeat()
	--SM(beat)

	-- Collect all the mods that will be applied in this frame into one string.
	-- Mod tweening doesn't work correctly if the mods are in seperate commands.

	local mods_this_frame= {}
	local function add_mod(mod_str)
		mods_this_frame[#mods_this_frame+1]= mod_str
	end
	local function execute_mods()
		if #mods_this_frame <= 0 then return end
		local total_mod_str= ""
		for i, ms in ipairs(mods_this_frame) do
			if #total_mod_str > 0 then
				total_mod_str= total_mod_str .. ", "
			end
			total_mod_str= total_mod_str .. ms
		end
		Handler_mod(total_mod_str)
	end
	
	while curmod<= #mods and GAMESTATE:GetSongBeat()>=mods[curmod][1] do
		add_mod(mods[curmod][2])
		curmod = curmod+1
	end

	execute_mods()
	
	while curmessage<= #messages and GAMESTATE:GetSongBeat()>=messages[curmessage][1] do
		if messages[curmessage][3] and GAMESTATE:GetSongBeat()>=messages[curmessage][1]+5 then
			curmessage = curmessage+1;
		else
			MESSAGEMAN:Broadcast(messages[curmessage][2])
			curmessage = curmessage+1;
		end
	end
end

local last_score_x = 0
local musicrate = GAMESTATE:GetSongOptionsObject("ModsLevel_Song"):MusicRate()
return Def.ActorFrame{

	OnCommand= function(self)
			Handler_init()
			self:SetUpdateFunction(Handler_update)
			local screen = SCREENMAN:GetTopScreen()
			-- Fade out everything but the SongBackground, SongForeground, and Player layers.
			-- In Simply Love (as of v4.8.5 anyway), player combos will unhide themselves,
			-- but that's okay for this stepchart.  If you need to hide combos in SL, call
			-- hibernate(math.huge) on each.  Sorry about that.
			-- don't fade out the theme's UI in EditMode
			-- Below was originally snipped From Watermelon by quietly-turning
			for name,layer in pairs(screen:GetChildren()) do
				if not (name=="SongBackground" or name=="SongForeground" or name=="Underlay" or name=="PlayerP1" or name=="PlayerP2") then
				--	layer:smooth(1.5):diffusealpha(0)
				end
				if (name=="SongBackground") then
				--	layer:visible(false)
				end
				if name == "In" then layer:visible(false) end
				if name == 'Underlay' then
				--	layer:visible(false)
					for player_index=1,2 do
						local score = layer:GetChild('P' .. player_index .. 'Score')					
						if score then score:visible(true):diffusealpha(1) end
					end
				end
			end

		end,

	Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000),
	},
	Def.Quad{
		InitCommand=function(self)
			self:visible(true):FullScreen()
			self:sleep(6):linear(25):diffusealpha(0)
		end,
		OnCommand=function(self)
			self:FullScreen():Center()
			--self:diffuse(1,1,1,0)
		end,
		NoDoorMessageCommand=function(self)
			self:linear(6):diffusealpha(1)
		end,
		LimeAwayMessageCommand=function(self)
			self:linear(55):diffusealpha(0)
		end,
		ApplesMessageCommand=function(self)
			self:linear(35):diffusealpha(1)
		end
	},
	Def.Sprite{
		Name= "BG",
		OnCommand=function(self)
			self:visible(false):diffusealpha(0):FullScreen()
		end,
		NoDoorMessageCommand=function(self)
			self:visible(true):linear(23):diffusealpha(0.9)
		end,
		LimeAwayMessageCommand=function(self)
			self:linear(35):diffusealpha(0.1)
		end,
		Texture= "bg.jpg";
	  },
	  LoadActor("Wind.mp4")..{				
		InitCommand= function(self)
				self:visible(false)
				local src_w = self:GetTexture():GetSourceWidth()
				self:Center():zoom(_screen.w/WideScale(src_w*0.75,src_w))
				self:animate(false):loop(false):diffusealpha(0)
				--Zoom the background video based on the width of the original mp4
				-- so that it fits perfectly in 16:9 and crop the sides in 4:3 borrowed' from quietly-turning's watermelon
		end,
		LimeAwayMessageCommand= function(self)
			self:visible(true):animate(true):loop(true):linear(19):diffusealpha(1)
		--	self:hibernate(0):diffusealpha(0):linear(1):diffusealpha(0.4):sleep(2):linear(0.5):diffusealpha(0.1)
		end,
	},
	Def.Sprite{
		Name= "BG",
		OnCommand=function(self)
			self:visible(false):diffusealpha(0):FullScreen()
		end,
		ApplesMessageCommand=function(self)
			self:visible(true):linear(16):diffusealpha(1)
		end,
		Texture= "phase.jpg",
	  },
	  Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P1Score then
				self:SetTarget(P1Score)
			end
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P2Score  then
				self:SetTarget(P2Score)
			end
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P1 then
				self:SetTarget(P1)
			end
		end
	},

	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P2 then
				self:SetTarget(P2)
			end
		end
	},
	Def.Quad{
		OnCommand=function(self)
			self:FullScreen():Center()
			self:diffuse(Color.White):linear(2):diffusealpha(0):visible(false)
		end,
	},
	Def.Quad{
		OnCommand=function(self)
			self:FullScreen():Center()
			self:diffuse(0,0,0,0)
		end,
		ParadiseMessageCommand= function(self)
			self:diffuse(Color.White)
			self:linear(10);
			self:diffuse(0,0,0,0.1)
		end,
		AppleMessageCommand= function(self)
			self:diffuse(Color.White)
			self:linear(12);
			self:diffusealpha(0)
		end,
	},
	Def.Quad{
		OnCommand=function(self)
			self:FullScreen():Center()
			self:diffuse(0,0,0,0)
		end,
		Paradise2MessageCommand= function(self)
			self:diffuse(Color.White)
			self:linear(10);
			self:diffuse(0,0,0,0)
		end,
	},
}